/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.sct.engine.step;

import com.quantumdata.sct.dao.vo.AbstractCommandVO;
import com.quantumdata.sct.dao.vo.CommandInvocationVO;
import com.quantumdata.sct.dao.vo.ParameterVO;
import com.quantumdata.sct.dao.vo.ServiceStepVO;
import com.quantumdata.sct.dao.vo.ServiceVO;
import com.quantumdata.sct.dao.vo.TestStepResultVO;
import com.quantumdata.sct.engine.EngineException;
import com.quantumdata.sct.engine.IEngine;
import com.quantumdata.sct.engine.IEngineContext;
import com.quantumdata.sct.engine.step.StepEngine;
import com.quantumdata.sct.engine.step.StepEngineContext;
import com.quantumdata.sct.gui.common.SCTCheckBox;
import com.quantumdata.sct.gui.common.SCTPanel;
import com.quantumdata.sct.gui.common.SCTTextArea;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Properties;
import javax.swing.BoxLayout;

public class ServiceStepEngine
extends StepEngine {
    private boolean status = false;
    private int errorStatus = 0;

    public ServiceStepEngine(ServiceStepVO serviceStepVO) {
        super(serviceStepVO);
    }

    public int execute(IEngineContext iEngineContext) throws EngineException {
        String string = null;
        String string2 = null;
        int n = 0;
        try {
            ParameterVO parameterVO = iEngineContext.getOutputParameter();
            if (parameterVO != null) {
                string = parameterVO.getName();
                string2 = parameterVO.getValue();
            }
            ServiceVO serviceVO = ((ServiceStepVO)this.stepVO).getServiceVO();
            IEngine iEngine = serviceVO.createEngine();
            IEngineContext iEngineContext2 = iEngine.prepareContext(iEngineContext);
            n = iEngine.execute(iEngineContext2);
            if (string == null || string2 == null) {
                this.status = parameterVO == null || !parameterVO.isRequired();
            } else {
                Object object = iEngineContext2.getParameter(string);
                if (object != null) {
                    this.status = false;
                    if (((ParameterVO)object).getValue().length() > 5 && ((ParameterVO)object).getValue().substring(0, 5).equalsIgnoreCase("ERROR")) {
                        this.errorStatus = 20000;
                    }
                    if (((ParameterVO)object).getValue().equalsIgnoreCase(string2)) {
                        this.status = true;
                    } else {
                        Thread.sleep(1000L);
                        n = iEngine.execute(iEngineContext2);
                        object = iEngineContext2.getParameter(string);
                        if (((ParameterVO)object).getValue().equalsIgnoreCase(string2)) {
                            this.status = true;
                        }
                    }
                }
            }
            if (n > 0) {
                this.errorStatus = n;
                this.status = false;
            }
            super.execute(iEngineContext);
            for (ParameterVO parameterVO2 : iEngineContext2.getInputParameters()) {
                TestStepResultVO testStepResultVO = ((StepEngineContext)iEngineContext).getStepResultVO();
                if (testStepResultVO == null) continue;
                testStepResultVO.getParameters().add(parameterVO2);
            }
        }
        catch (Exception exception) {
            this.status = false;
            this.errorStatus = 20003;
        }
        this.resetStatus();
        return 0;
    }

    public boolean getStatus() {
        return this.status;
    }

    public int getError() {
        return this.errorStatus;
    }

    public void setError(int n) {
        this.errorStatus = n;
    }

    public void resetStatus() {
        this.status = false;
        this.errorStatus = 0;
    }

    public SCTPanel getDisplay(Properties properties) {
        SCTCheckBox sCTCheckBox = null;
        if (properties.getProperty("StepCountValue") != null) {
            try {
                sCTCheckBox = (SCTCheckBox)properties.get("ResultCheckBox");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        SCTPanel sCTPanel = new SCTPanel(new BorderLayout());
        if (sCTCheckBox != null) {
            sCTCheckBox.setText(this.stepVO.getDescription());
            sCTPanel.add(sCTCheckBox);
        } else {
            sCTPanel.add(new SCTTextArea(this.stepVO.getDescription()));
        }
        boolean bl = false;
        try {
            bl = Boolean.getBoolean("com.quantumdata.sct.test.debug");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bl) {
            ServiceStepVO serviceStepVO = (ServiceStepVO)this.stepVO;
            SCTPanel sCTPanel2 = new SCTPanel();
            BoxLayout boxLayout = new BoxLayout(sCTPanel2, 1);
            sCTPanel2.setLayout(boxLayout);
            String string = "Invoking Service (" + serviceStepVO.getServiceName() + ")";
            SCTTextArea sCTTextArea = new SCTTextArea(string);
            sCTPanel2.add(sCTTextArea);
            try {
                for (CommandInvocationVO commandInvocationVO : serviceStepVO.getServiceVO().getCommandInvocations()) {
                    AbstractCommandVO abstractCommandVO = commandInvocationVO.getCommand();
                    String string2 = abstractCommandVO.toString();
                    SCTTextArea sCTTextArea2 = new SCTTextArea(string2);
                    sCTPanel2.add(sCTTextArea2);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            sCTPanel.add((Component)sCTPanel2, "Center");
        }
        return sCTPanel;
    }
}

